#!/bin/sh
#
# Automatically archives messages in the mailbox "autoarchive".

# Mailbox with messages that we have to sort
INPATH=~/mail/IN.ccc-intern
INPATH2=~/mail/IN.security-alerts

# we use this directory to make sure this script only runs once at a
# time.
LOCKDIR=$INPATH/lock

# directory with a procmail script that we need.
DATADIR=~/.bin/cron-email-autoarchive

mkdir $LOCKDIR || {
    echo "Error:  could not mkdir $LOCKDIR." >&2
    exit 1
}

# Learn new spam mail and move to archive.
for i in `find $INPATH/cur -type f -name '*S'`; do
  cat "$i" | formail | procmail $DATADIR/movetoarchive.procmail
  rm "$i"
done

# Learn new spam mail and move to archive.
for i in `find $INPATH2/cur -type f -name '*S'`; do
  cat "$i" | formail | procmail $DATADIR/movetoarchive.procmail
  rm "$i"
done

rmdir $LOCKDIR || {
    echo "Error:  could not rmdir $LOCKDIR." >&2
    exit 1
}

exit 0
